#include <iostream>
#include <cstdio>
#include <queue>
#include <cstring>
using namespace std;

int main() {
    int ts;
    scanf("%d\n", &ts);

    for (int t = 0; t < ts; t++) {
        int n, want;
        scanf("%d %d\n", &n, &want);

        int *dist = new int[3601];
        memset(dist, -1, 3601 << 2);

        int *sw = new int[n];
        for (int i = 0 ; i < n; i++) {
            scanf("%d", sw + i);
        }

        queue<int> Q;
        dist[0] = 0;
        Q.push(0);

        while (!Q.empty()) {
            int cur = Q.front();
            Q.pop();

            for (int i = 0; i < n; i++) {
                int nxt = cur + sw[i];
                nxt = max(0, nxt);
                nxt = min(3600, nxt);
                if (dist[nxt] == -1 || dist[nxt] > dist[cur] + 1) {
                    dist[nxt] = 1 + dist[cur];
                    Q.push(nxt);
                }
            }
        }

        for (int i = want; ; i++) {
            if (dist[i] >= 0) {
                printf("%d %d\n", dist[i], i - want);
                break;
            }
        }
    }

    return 0;
}
